// Projekt nr 54  stosowanie zewntrznej pamici EEPROM
#include <Wire.h>
#define chip1 0x50

unsigned int pointer;
byte d=0;

void setup()
{
   Serial.begin(9600);
   Wire.begin();
}

void writeData(int device, unsigned int address, byte data)
// zapisuje bajt danych reprezentowany przez zmienn data w pamici EEPROM podczonej do magistrali I2C (adres device);
// bajt jest zapisywany na pozycji address
{
   Wire.beginTransmission(device);
   Wire.write((byte)(address >> 8));   // lewa cz wskanika address
   Wire.write((byte)(address & 0xFF)); // prawa cz wskanika
   Wire.write(data);
   Wire.endTransmission();
   delay(10);
}

byte readData(int device, unsigned int address)
// odczytuje bajt danych z pozycji address w pamici
// podczonej do magistrali I2C i reprezentowanej przez adres device
{
   byte result; // zwrcona warto
   Wire.beginTransmission(device);
   Wire.write((byte)(address >> 8));   // lewa cz wskanika address
   Wire.write((byte)(address & 0xFF)); // prawa cz wskanika
   Wire.endTransmission();
   Wire.requestFrom(device,1);
   result = Wire.read();
   return result; // zwraca odczytan warto jako wynik funkcji readData
}

void loop()
{
   Serial.println("Zapisywanie danych...");
   for (int a=0; a<20; a++)
   {
      writeData(chip1,a,a);
   }
   Serial.println("Odczytywanie danych...");
   for (int a=0; a<20; a++)
   {
      Serial.print("Pozycja w pamici EEPROM ");
      Serial.print(a);
      Serial.print(" zawiera ");
      d=readData(chip1,a);
      Serial.println(d, DEC);
   }
}
