// Projekt nr 43  wykrywanie kolizji robota za pomoc ultradwikowego
// czujnika odlegoci

int m1speed=6; // piny cyfrowe uywane do sterowania szybkoci
int m2speed=5;
int m1direction=7; // piny cyfrowe uywane do sterowania kierunkiem pracy silnikw
int m2direction=4;
int signal=3;
boolean crash=false;

void setup()
{
   pinMode(m1direction, OUTPUT);
   pinMode(m2direction, OUTPUT);
   pinMode(signal, OUTPUT);
   delay(5000);
   Serial.begin(9600);
}

int getDistance()
// zwraca odlego (w centymetrach) wykryt przez czujnik Ping)))
{
   int distance;
   unsigned long pulseduration=0;

   // pobiera pomiar czujnika odlegoci Ping)))
   // ustawia pin wyjciowy potrzebny do wysania impulsu
   pinMode(signal, OUTPUT);

   // ustawia stan LOW na tym pinie
   digitalWrite(signal, LOW);
   delayMicroseconds(5);

   // wysya impuls trwajcy 5 mikrosekund, aby aktywowa czujnik Ping)))
   digitalWrite(signal, HIGH);
   delayMicroseconds(5);
   digitalWrite(signal, LOW);

   // zmienia tryb pracy pinu cyfrowego na wejcie, aby odczyta impuls przychodzcy
   pinMode(signal, INPUT);

   // mierzy dugo impulsu przychodzcego
   pulseduration=pulseIn(signal, HIGH);

   // dzieli dugo impulsu przez dwa
   pulseduration=pulseduration/2;

   // konwertuje czas impulsu na centymetry
   distance = int(pulseduration/29);
   return distance;
}

void backUp()
{
   digitalWrite(m1direction,LOW); // ruch w ty
   digitalWrite(m2direction,LOW);
   delay(2000);
   digitalWrite(m1direction,HIGH); // ruch w lewo
   digitalWrite(m2direction,LOW);
   analogWrite(m1speed, 200); // szybko
   analogWrite(m2speed, 200);
   delay(2000);
   analogWrite(m1speed, 0); // szybko
   analogWrite(m2speed, 0);
}

void goForward(int duration, int pwm)
{
   long a,b;
   int dist=0;
   boolean move=true;
   a=millis();
   do
   {
      dist=getDistance();
      Serial.println(dist);
      if (dist<10) // jeli odlego do obiektu jest mniejsza ni 10 cm
      {
         crash=true;
      }
      if (crash==false)
      {
         digitalWrite(m1direction,HIGH); // ruch w przd
         digitalWrite(m2direction,HIGH); // ruch w przd
         analogWrite(m1speed, pwm); // szybko
         analogWrite(m2speed, pwm);
      }
      if (crash==true)
      {
         backUp();
         crash=false;
      }
      b=millis()-a;
      if (b>=duration)
      {
         move=false;
      }
   } while (move!=false);
   // zatrzymuje silniki
   analogWrite(m1speed, 0);
   analogWrite(m2speed, 0);
}

void loop()
{
   goForward(1000, 255);
}
