// Projekt nr 33  tworzenie zamka sterowanego klawiatur numeryczn

// Pocztek niezbdnego kodu

#include "Keypad.h"
const byte ROWS = 4; // ustawia ukad zoony z czterech wierszy
const byte COLS = 3; // ustawia ukad zoony z trzech kolumn
char keys[ROWS][COLS] =
 {{'1','2','3'},
   {'4','5','6'},
   {'7','8','9'},
   {'*','0','#'}};
byte rowPins[ROWS] = {5, 4, 3, 2};
byte colPins[COLS] = {8, 7, 6};
Keypad keypad = Keypad( makeKeymap(keys), rowPins, colPins, ROWS, COLS );

// Koniec niezbdnego kodu

char PIN[6]={'1','2','3','4','5','6'}; // tajna liczba
char attempt[6]={0,0,0,0,0,0};
int z=0;

void setup()
{
   Serial.begin(9600);
}

void correctPIN() // funkcja wywoywana, jeli wpisano poprawny kod PIN
{
   Serial.println("Wpisano prawidowy kod PIN...");
}

void incorrectPIN() // funkcja wywoywana, jeli kod PIN jest nieprawidowy
{
   Serial.println("Wpisano nieprawidowy kod PIN!");
}

void checkPIN()
{
   int correct=0;
   int i;
   for ( i = 0; i < 6 ; i++ )
   {
      if (attempt[i]==PIN[i])
      {
         correct++;
      }
   }
   if (correct==6)
   {
      correctPIN();
   } else
   {
      incorrectPIN();
   }
   for (int zz=0; zz<6; zz++) // usuwa kod PIN wpisany w poprzedniej prbie
   {
      attempt[zz]=0;
   }
}

void readKeypad()
{
   char key = keypad.getKey();
   if (key != NO_KEY)
   {
      switch(key)
      {
         case '*':
            z=0;
            break;
         case '#':
            delay(100); // eliminuje skutki zjawiska drgania stykw
            checkPIN();
            break;
         default:
            attempt[z]=key;
            z++;
      }
   }
}

void loop()
{
   readKeypad();
}
