// Projekt nr 19  sterowanie dwoma moduami wywietlaczy siedmiosegmentowych LED

#define DATA 6       // poczenie z pinem nr 14 rejestru 74HC595
#define LATCH 8      // poczenie z pinem nr 12 rejestru 74HC595
#define CLOCK 10     // poczenie z pinem nr 11 rejestru 74HC595

// definiuje tablic z dziesitn reprezentacj segmentw wywietlacza dla cyfr od 0 do 9 i liter od A do F (patrz tabela 6.2)
int digits[] = {252, 96, 218, 242, 102, 182, 190, 224, 254, 246, 238, 62, 156, 122, 158, 142};

void setup()
{
   pinMode(LATCH, OUTPUT);
   pinMode(CLOCK, OUTPUT);
   pinMode(DATA, OUTPUT);
}

void displayNumber(int n)
{
   int left, right=0;
   if (n < 10)
   {
      digitalWrite(LATCH, LOW);
      shiftOut(DATA, CLOCK, LSBFIRST, digits[n]);
      shiftOut(DATA, CLOCK, LSBFIRST, 0);
      digitalWrite(LATCH, HIGH);
   }
   else if (n >= 10)
   {
      right = n % 10; // reszta z dzielenia wywietlanej liczby przez 10
      left = n / 10; // wynik dzielenia liczby do wywietlenia przez 10
      digitalWrite(LATCH, LOW);
      shiftOut(DATA, CLOCK, LSBFIRST, digits[right]);
      shiftOut(DATA, CLOCK, LSBFIRST, digits[left]);
      digitalWrite(LATCH, HIGH);
   }
}

void loop()
{
   int i;
   for ( i = 0 ; i < 100 ; i++ )
   {
      displayNumber(i);
      delay(100);
   }
}
