// Listing 12.3

int signal=3;

void setup()
{
   pinMode(signal, OUTPUT);
   Serial.begin(9600);
}

int getDistance()
// zwraca odlego (w centymetrach) wykryt przez czujnik Ping)))
{
   int distance;
   unsigned long pulseduration=0;

   // pobiera pomiar czujnika odlegoci Ping)))
   // ustawia pin wyjciowy potrzebny do wysania impulsu
   pinMode(signal, OUTPUT);

   // ustawia stan LOW na tym pinie
   digitalWrite(signal, LOW);
   delayMicroseconds(5);

   // wysya impuls trwajcy 5 mikrosekund, aby aktywowa czujnik Ping)))
   digitalWrite(signal, HIGH);
   delayMicroseconds(5);
   digitalWrite(signal, LOW);

   // zmienia tryb pracy pinu cyfrowego na wejcie, aby odczyta impuls przychodzcy
   pinMode(signal, INPUT);

   // mierzy dugo impulsu przychodzcego
   pulseduration=pulseIn(signal, HIGH);

   // dzieli dugo impulsu przez dwa
   pulseduration=pulseduration/2;

   // konwertuje czas impulsu na centymetry
   distance = int(pulseduration/29);
   return distance;
}

void loop()
{
   Serial.print(getDistance());
   Serial.println(" cm");
   delay(500);
}
