// Projekt nr 27  budowa szybkiego termometru z wywietlan histori

#include <glcd.h>                // docza bibliotek dla graficznego moduu LCD
#include <fonts/SystemFont5x7.h> // docza standardowe czcionki dla tego moduu

int tcurrent;
int tempArray[100];

void setup()
{
   GLCD.Init(NON_INVERTED); // konfiguruje modu GLCD
   GLCD.ClearScreen();      // wycza wszystkie piksele moduu GLCD
   GLCD.SelectFont(System5x7);
}

void getTemp() // funkcja odczytujca temperatur z czujnika TMP36
{
   float sum = 0;
   float voltage = 0;
   float sensor = 0;
   float celsius;

   // odczytuje temperatur i konwertuje wynik na stopnie Celsjusza
   sensor   = analogRead(5);
   voltage  = (sensor * 5000) / 1024;
   voltage  = voltage - 500;
   celsius  = voltage / 10;
   tcurrent = int(celsius);

   // umieszcza now temperatur na pocztku tablicy z histori temperatur
   for (int a = 99 ; a >= 0 ; --a )
   {
      tempArray[a] = tempArray[a-1];
   }
   tempArray[0] = tcurrent;
}

void drawScreen() // generuje efekty wizualne na wywietlaczu GLCD
{
   int q;
   GLCD.ClearScreen();
   GLCD.CursorTo(5, 0);
   GLCD.Puts("Aktualna:");
   GLCD.PrintNumber(tcurrent);
   GLCD.CursorTo(0, 1);
   GLCD.PrintNumber(40);
   GLCD.CursorTo(0, 2);
   GLCD.PrintNumber(32);
   GLCD.CursorTo(0, 3);
   GLCD.PrintNumber(24);
   GLCD.CursorTo(0, 4);
   GLCD.PrintNumber(16);
   GLCD.CursorTo(1, 5);
   GLCD.PrintNumber(8);
   GLCD.CursorTo(1, 6);
   GLCD.PrintNumber(0);
   for (int a = 28 ; a < 127 ; a++)
   {
      q = (55 - tempArray[a-28]);
      GLCD.SetDot(a, q, BLACK);
   }
}

void loop()
{
   getTemp();
   drawScreen();
   for (int a = 0 ; a < 20 ; a++) // czeka 20 minut przed nastpnym odczytem
   {
      delay(60000); // czeka 1 minut
   }
}
