//
//  Xboxhidboot.cpp
//  


#include "xboxhidboot.h"

void XboxReportParser::Parse(HID *hid, bool is_rpt_id, uint8_t len, uint8_t *buf)
{
    XBOXINFO	*pmi = (XBOXINFO*)buf;
    
    // Sprawdzenie bajtu informacji o przyciskach
    if (buf[2] != 0)
    {
        if ((buf[2] >> 0) & 1)
            onDPadUp(pmi);
        
        if ((buf[2] >> 1) & 1)
            onDPadDown(pmi); 
        
        if ((buf[2] >> 2) & 1)
            onDPadLeft(pmi);
        
        if ((buf[2] >> 3) & 1)
            onDPadRight(pmi);
        
        if ((buf[2] >> 4) & 1)
            onStartButton(pmi);
        
        if ((buf[2] >> 5) & 1)
            onBackButton(pmi);
        
        if ((buf[2] >> 6) & 1)
            onLeftStickPress(pmi);
        
        if ((buf[2] >> 7) & 1)
            onRightStickPress(pmi);
    }
    
    // Sprawdzenie bajtu informacji o przyciskach
    if (buf[3] != 0)
	{
		if ((buf[3] >> 0) & 1)
			onButtonLB(pmi);
        
		if ((buf[3] >> 1) & 1)
			onButtonRB(pmi);
        
		if ((buf[3] >> 2) & 1)
			onButtonLogo(pmi);
        
		if ((buf[3] >> 4) & 1)
			onButtonA(pmi);
		
		if ((buf[3] >> 5) & 1)
			onButtonB(pmi);
		
		if ((buf[3] >> 6) & 1)
			onButtonX(pmi);
        
		if ((buf[3] >> 7) & 1)
			onButtonY(pmi);			
	}
	
    // Sprawdzenie stanu spustw
	if (pmi->bmLeftTrigger != 0)
		onLeftTrigger(pmi);
    
	if (pmi->bmRightTrigger != 0)
		onRightTrigger(pmi);
	
    // Sprawdzenie ruchu joysticka
	if (prevState.xboxInfo.bmLeftStickXAxis != pmi->bmLeftStickXAxis || prevState.xboxInfo.bmLeftStickYAxis != pmi->bmLeftStickYAxis)
		onLeftStickMove(pmi);
    
	if (prevState.xboxInfo.bmRightStickXAxis != pmi->bmRightStickXAxis || prevState.xboxInfo.bmRightStickYAxis != pmi->bmRightStickYAxis)
		onRightStickMove(pmi);
    
	for (uint8_t i=0; i<14; i++) 
		prevState.bInfo[i] = buf[i];
	
    
};
