/* 
 Sterowanie silnikiem krokowym - jeden krok na raz
 
 Ten program suy do sterowania silnikiem unipolarnym i bipolarnym.
 Silnik jest doczony do pinw cyfrowych 8 - 11 Arduino

 Silnik bdzie wykonywa jeden krok na raz, bardzo powoli. Moesz wykorzysta
 ten kod do sprawdzenia, czy prawidowo podczye cztery kocwki silnika
 do odpowiednich pinw. Jeeli poczenia s poprawne, wszystkie kroki powinny
 by wykonane w tym samym kierunku.
 
 Uyj go rwnie do zliczenia krokw do wykonania penego obrotu Twojego silnika,
 jeeli tego nie wiesz. Wpisz t warto w przykadzie oneRevolution aby sprawdzi,
 czy jest poprawna.
 
 Utworzono 30 listopada 2009
 Autor: Tom Igoe
 
 */

#include <Stepper.h>

const int stepsPerRevolution = 200;  // Zmie t warto na liczb krokw na obrt
                                     // twojego silnika

// Zainicjowanie biblioteki do sterowania silnikiem krokowym na pinach od 9 do 11:
Stepper myStepper(stepsPerRevolution, 8,9,10,11);            

int stepCount = 0;         // Liczba krokw wykonanych przez silnik

void setup() {
  // Zainicjowanie portu szeregowego:
  Serial.begin(9600);
}

void loop() {
  // Krok po kroku:
  myStepper.step(1);
  Serial.print("Kroki:" );
  Serial.println(stepCount);
  stepCount++;
  delay(500);
}
