import processing.serial.*;
import cc.arduino.*;

import ddf.minim.analysis.*;
import ddf.minim.*;

static final int FIRST_LED = 3;
static final int SECOND_LED = 5;
static final int THIRD_LED = 6;
static final int FOURTH_LED = 10;
static final int FIFTH_LED = 11;

float bins[];

Arduino arduino;

FFT fft;
Minim minim;
AudioPlayer player;

void setup()
{
  size( 300, 300 );

  arduino = new Arduino(this, Arduino.list()[0], 57600);

  minim = new Minim(this)

  player = minim.loadFile("song.mp3");
  player.loop();

  fft = new FFT(player.bufferSize(), player.sampleRate());  

  bins = new float[5];
}

void draw()
{
  background(0);

  fft.forward(player.mix);

  int bands = fft.specSize() / 5;

  for (int i = 0; i < 5; i++) {
    bins[i] = 0;
    for( int j = 0; j < bands; j++) {  
      bins[i] += fft.getBand((i * bands) + j);
    }
    bins[i] /= bands;
    rect( i * 20, 0, 20, bins[i]);
  }

  arduino.analogWrite(FIRST_LED, (int) map(bins[0], 0, 10, 0, 255));  
  arduino.analogWrite(SECOND_LED, (int) map(bins[1], 0, 10, 0, 255));
  arduino.analogWrite(THIRD_LED, (int) map(bins[2], 0, 10, 0, 255));
  arduino.analogWrite(FOURTH_LED, (int) map(bins[3], 0, 10, 0, 255));
  arduino.analogWrite(FIFTH_LED, (int) map(bins[4], 0, 10, 0, 255));
}

void stop()
{
  player.close();
  minim.stop();
  super.stop();
}
