#include <WiFi.h>

char ssid[] = "network_name";
char pass[] = "network_key";
IPAddress server_address(192,168,0,1);
int server_port = 10000;
int status = WL_IDLE_STATUS;

WiFiClient client;

void setup() {
  Serial.begin(9600);
  connectToNetwork();  
}

void connectToNetwork(){
  //if not connected to a network, attempt to connect:
  while ( status != WL_CONNECTED) { 
    Serial.print("Attempting to connect to SSID: ");
    Serial.println(ssid);
    // Connect to WPA/WPA2 network. Change this line if using open or WEP network:    
    status = WiFi.begin(ssid, pass);

    // wait 10 seconds for connection:
    delay(10000);
  } 
  
  //print the status once connected
  printWifiStatus();
}

void loop() {
  //if the wifly is connected to the network
  if(status == WL_CONNECTED){
    //if not yet connected to a server
    if(!client.connected())
    {
      //attempt to connect to the server
      client.connect(server_address, server_port);
      delay(1000); //give a little time before retrying
    }
    
    //otherwise, if we're already connected to a server
    else 
    {
      //print out that we are sending data, read analog inputs 0 and 1, and
      //then send out the data over the Wifi shield to the server
      Serial.print("Connected and sending data to ");
      Serial.println(server_address);
      client.print("x: ");
      client.print(analogRead(0));
      client.print(" y: ");
      client.print(analogRead(1));
      client.print(" z: ");
      client.println(analogRead(2));
    } 

    delay(20); //wait 20ms between readings

  }
  else{
    Serial.println("wifi not up");
    connectToNetwork();
  }
}

void printWifiStatus() {
  // print the SSID of the network you're attached to:
  Serial.print("SSID: ");
  Serial.println(WiFi.SSID());

  // print your WiFi shield's IP address:
  IPAddress ip = WiFi.localIP();
  Serial.print("IP Address: ");
  Serial.println(ip);

  // print the received signal strength:
  long rssi = WiFi.RSSI();
  Serial.print("signal strength (RSSI):");
  Serial.print(rssi);
  Serial.println(" dBm");
}



