#include <SPI.h>
#include <Ethernet.h>

byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED }; 
IPAddress manualIP(192,168,1,120); 

EthernetServer server(80); 

boolean dhcpConnected = false;

void setup()
{
  if (!Ethernet.begin(mac)){ 
    Ethernet.begin(mac, manualIP); 
  }  

  server.begin(); 
}

void loop()
{
  EthernetClient client = server.available(); 
  if (client) {
    boolean currentLineIsBlank = true;
    while (client.connected()) { 
      if (client.available()) { 
        char c = client.read(); 

        if (c == '\n' && currentLineIsBlank) { 
          client.println("HTTP/1.1 200 OK"); 
          client.println("Content-Type: text/html"); 
          client.println(); 
          client.println("Witaj, jestem Twoim serwerem Arduino!"); 

          break;
        }
        if (c == '\n') {
          currentLineIsBlank = true;
        } 
        else if (c != '\r') {
          currentLineIsBlank = false;
        }
      }
    }
    delay(1); 
    client.stop(); 
  }
}

