#include <SPI.h>
#include <Ethernet.h>
#include <Twitter.h>

byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED }; // Adres moe by ustawiony rcznie, aby unikn konfliktw zastosuj adres z etykiety
IPAddress manualIP(192,168,1,120); // Odpowiedni adres z Twojej sieci

int b1Pin = 2;
int pressCount = 0;

Twitter twitter("TWOJ-TOKEN");

void setup()
{
   // Prba poczenia przy uyciu automatycznie przypisanego adresu IP (DHCP).
   // W przeciwnym wypadku uyty bdzie adres przypisany rcznie 
  delay(1000);
  if(!Ethernet.begin(mac)){
    Ethernet.begin(mac, manualIP);
  }
  Serial.begin(9600);

}

void sendTweet(const char msgToSend[])
{
  Serial.println("Laczenie...");
  if (twitter.post(msgToSend)) {
    int status = twitter.wait(&Serial);
    if (status == 200) {
      Serial.println("OK.");
    } 
    else {
      Serial.print("Blad : kod ");
      Serial.println(status);
    }
  } 
  else {
    Serial.println("Polaczenie nieudane.");
  }
}

void loop()
{
  if(digitalRead(b1Pin) == HIGH)
  {
    pressCount++;
    sendTweet("Liczba nacisniec przycisku: " + pressCount);
    delay(2000); 
  }

}


