// szkic Processing
              
/*
 * ReceiveMultipleFieldsBinary_P
 *
 * portIndex musi być równy numerowi portu podłączonego do Arduino
*/

import processing.serial.*;

Serial myPort;        // tworzenie obiektu klasy Serial
short portIndex = 0;  // wybór portu szeregowego, 0 oznacza pierwszy port

char HEADER = 'H';

void setup()
{
  size(200, 200);
  // Otwórz port, do którego podłączone jest Arduino.
  String portName = Serial.list()[portIndex];
  println(Serial.list());
  println(" Łączenie z -> " + portName);
  myPort = new Serial(this, portName, 9600);
}

void draw()
{
int val;

  if ( myPort.available() >= 15)  // Poczekaj, aż zostanie otrzymana cała wiadomość.
  {
    if( myPort.read() == HEADER) // Czy to jest nagłówek?
    {
      println("Wiadomość odebrana:");
      // nagłówek znaleziony
      // Odbierz liczbę całkowitą zawierająca wartości bitów.
      val = readArduinoInt();
      // wyświetlanie wartości każdego bitu
      for(int pin=2, bit=1; pin <= 13; pin++){
        print("pin cyfrowy " + pin + " = " );
        int isSet = (val & bit);
        if( isSet == 0) {
          println("0");
        }
        else{
          println("1");
        }
        bit = bit * 2; //Przesuń bit na kolejne, wyższe miejsce
      }
      println();
      // wyświetl sześć analogowych wartości
      for(int i=0; i < 6; i ++){
        val = readArduinoInt();
        println("pin analogowy " + i + "=" + val);
      }
      println("----");
    }
  }
}

// Zwróć liczbę całkowitą złożoną z otrzymanych bajtow (najpierw dolny bajt, potem górny).
int readArduinoInt()
{
  int val;      // dane odebrane z portu szeregowego

  val = myPort.read();              // odczytaj najmniej znaczący bajt
  val = myPort.read() * 256 + val;  // dodaj najbardziej znaczący bajt
  return val;
}
