/*
 * Szkic i2c_master_multiple
 * Wysyła kilka danych z czujnika do urządzenia podrzędnego I2C za pomocą print
 */

#include <Wire.h>

const int address = 4;          // Adres używany przez komunikujące się ze sobą urządzenia
const int firstSensorPin = A0;  // Pierwszy pin wejścia
const int nbrSensors = 3;       // Będą używane trzy sąsiadujące ze sobą piny
int val;                        // Zmienna przechowująca wartości czujnika

void setup()
{
  Wire.begin();
  Serial.begin(9600);
}

void loop()
{
  Wire.beginTransmission(address); // Przesyłanie do urządzenia
  Wire.print('H'); // Nagłówek wskazujący na początek wiadomości
  Wire.print(nbrSensors);

  for (int i = 0; i < nbrSensors; i++) {
    val = analogRead(firstSensorPin + 1);  // Odczyt czujnika
    Wire.print(','); // Przecinek oddzielający kolejne wartości 
    Wire.print(val);  
  }

  Wire.println(); // Koniec wiadomości
  Wire.endTransmission();
  delay(100);
}
