/*
 * szkic tft_ST7735_Uno
 * Wyświetla tekst i poruszającą się po ekranie żółtą kulkę
 */

#include <Adafruit_GFX.h>    // podstawowa biblioteka obsługująca grafikę
#include <Adafruit_ST7735.h> // biblioteka obsługująca kontroler ST7735
#include <SPI.h>

// Zdefiniuj połączenia dla swojego panelu. Będą one różne w zależności od Twojego wyświetlacza i płytki.
#define TFT_CS   10
#define TFT_RST  9 
#define TFT_DC   8
#define TFT_BACKLIGHT  7
Adafruit_ST7735 tft = Adafruit_ST7735(TFT_CS, TFT_DC, TFT_RST);

void setup(void) 
{
  tft.initR(INITR_BLACKTAB); // inicjalizacja chipu ST7735R Init ST7735R wyświetlacza LCD 1.8" 128x160 
  
  pinMode(TFT_BACKLIGHT, OUTPUT); // pin podświetlenia
  digitalWrite(TFT_BACKLIGHT, HIGH); // włączenie podświetlenia
  
  tft.setRotation(2); // zależne od tego, jak zamontowałeś swój panel

  tft.fillScreen(ST77XX_BLACK); // wypełnienie ekranu czarnym kolorem

  // wyświetlenie różnego formatu tekstu (różne czcionki i rozmiary)
  tft.setCursor(0, 0);
  tft.setTextWrap(false);

  tft.setTextColor(ST77XX_RED);
  tft.setTextSize(1);
  tft.println("Mały");

  tft.setTextColor(ST77XX_GREEN);
  tft.setTextSize(2);
  tft.println("Średni");

  tft.setTextColor(ST77XX_BLUE);
  tft.setTextSize(3);
  tft.println("Duży");
}

int ballDir = 1;          // aktualny kierunek ruchu
int ballDiameter = 8;     // średnica kulki
int ballX = ballDiameter; // początkowa pozycja x
void loop() 
{
  // Jeśli kulka zbliża się do brzegu ekranu, odwróć kierunek.
  if (ballX >= tft.width() - ballDiameter || ballX < ballDiameter) {
    ballDir *= -1;
  }

  ballX += ballDir; // zmiana pozycji x kulki

  // obliczenie pozycji y na podstawie pozycji kursora
  int ballY = tft.getCursorY() + ballDiameter*2;

  tft.fillCircle(ballX, ballY, ballDiameter/2, 0xffff00); // żółta kulka
  delay(25);
  tft.fillCircle(ballX, ballY, ballDiameter/2, 0x000000); // usuwanie kulki z ekranu
}
