/* Szkic gps_sofr_serial
 * Szkic GPS wyświetlające dane w monitorze portu szeregowego
 */

#include "TinyGPS++.h"

// Usuń poniższe cztery linie, jeśli płytka ma osobne sprzętowe piny szeregowe
#include "SoftwareSerial.h"
#define GPS_RX_PIN 2
#define GPS_TX_PIN 3
SoftwareSerial softserial(GPS_RX_PIN, GPS_TX_PIN); // Stworzenie programowego obiektu szeregowego

// Jeśli Twoja płytka  ma osobny port szeregowy, zmień "softserial" na poniższą linijkę 
#define GPS_SERIAL softserial

TinyGPSPlus gps; // Utworzenie obiektu TinyGPSPlus

void setup()
{
  Serial.begin(9600); // Potrzebne do debugowania
  GPS_SERIAL.begin(9600); // Do komunikacji z modułem GPS, użyj obiektu SoftSerial
}
void loop()
{
  while (GPS_SERIAL.available())
  {
    int c = GPS_SERIAL.read();
    Serial.write(c); // Wyświetlenie danych NMEA

    // Przekazanie każdego bajta do funkcji encode()
    // Sprawdź nową pozycję jeśli funkcja encode() zwróci "True"
    if (gps.encode(c))
    {
      Serial.println();
      float lat = gps.location.lat();
      float lng = gps.location.lng();
      unsigned long fix_age = gps.date.age();
    
      if (!gps.location.isValid())
        Serial.println("Niepoprawna pozycja");
      else if (fix_age > 2000)
        Serial.println("Stara pozycja");
      else
        Serial.println("Poprawna pozycja");
      
      Serial.print("Szerokość: "); 
      Serial.print(lat);
      Serial.print(" Długość: "); 
      Serial.println(lng);
    }
  }
}
