/* szkic PN532_I2C
 *  Czytnik NFC - I2C
 * Odczytuje etykietę NFC i wyświetla jej unikalny numer identyfikacyjny. 
 */
 
#include <Wire.h>
#include <NfcAdapter.h>
#include <PN532/PN532/PN532.h>
#include <PN532/PN532_I2C/PN532_I2C.h>

PN532_I2C pn532i2c(Wire);
NfcAdapter nfc = NfcAdapter(pn532i2c);

void setup() 
{
  Serial.begin(9600);
  nfc.begin(); // inicjalizacja czytnika NFC
}

void loop() 
{
  Serial.println("Czekanie na zbliżenie etykiety do czytnika");
  if (nfc.tagPresent()) // Jeśli czytnik widzi etykietę NFC,
  {
    NfcTag tag = nfc.read(); // odczytuje ją
    Serial.println(tag.getUidString()); // i wyświetla jej ID.
  }
  delay(500);
}
