/*
  Szkic Keypad
  Wyświetla naciśnięte klawisze w monitorze portu szeregowego
*/

const int numRows = 4;       // Liczba wierszy na klawiaturze
const int numCols = 3;       // Liczba kolumn
const int debounceTime = 20; // Liczba milisekund potrzebnych na ustabilizowanie przycisku

// Tablica klawiszy ze znakami, które mają być zwrócone dla odpowiednich klawiszy
const char keymap[numRows][numCols] = {
  { '1', '2', '3'  } ,
  { '4', '5', '6'  } ,
  { '7', '8', '9'  } ,
  { '*', '0', '#'  }
};

// Tablica z pinami użytymi dla wierszy i kolumn
const int rowPins[numRows] = {8, 7, 6, 5}; // Wiersze od 0 do 3
const int colPins[numCols] = {4, 3, 2};    // Kolumny od 0 do 2

void setup()
{
  Serial.begin(9600);
  for (int row = 0; row < numRows; row++)
  {
    pinMode(rowPins[row],INPUT_PULLUP); // Ustawienie pinów wierszy jako wejść z aktywowanym rezystorem podciągającym
  }
  for (int column = 0; column < numCols; column++)
  {
    pinMode(colPins[column],OUTPUT);     // Ustawienie pinów kolumn jako wyjść
    digitalWrite(colPins[column],HIGH);  // Dezaktywacja wszystkich kolumn 
  }
}

void loop()
{
  char key = getKey();
  if( key != 0) { // Jeśli znak nie jest zerem, to znaczy, że jest to prawidłowe wciśnięcie klawisza
    Serial.print("Wciśnięty klawisz ");
    Serial.println(key);
  }
}

// Funkcja zwraca naciśnięty klawisz lub 0, jeśli nie został naciśnięty żaden klawisz
char getKey()
{
  char key = 0;                                  // 0 wskazuje, że nie został naciśnięty żaden klawisz

  for(int column = 0; column < numCols; column++)
  {
    digitalWrite(colPins[column],LOW);         // Aktywowanie bieżącej kolumny
    for(int row = 0; row < numRows; row++)     // Sprawdź wszystkie wiersze, czy nie został wciśnięty klawisz
                                          
    {
      if(digitalRead(rowPins[row]) == LOW)     // Czy został wciśnięty klawisz?
      {
        delay(debounceTime);                   // Ustabilizowanie styków
        while(digitalRead(rowPins[row]) == LOW)
            ;                                  // Poczekaj, aż klawisz zostanie zwolniony
        key = keymap[row][column];             // Zapamiętaj, który klawisz został wciśnięty
                                    
        Serial.print("pin wiersza: "); Serial.print(rowPins[row]);
        Serial.print(" pin kolumny: "); Serial.print(colPins[column]);
        Serial.print(" wiersz: "); Serial.print(row);
        Serial.print(" kolumna: "); Serial.println(column);
      }
    }
    digitalWrite(colPins[column],HIGH);     // Dezaktywuj bieżącą kolumnę
  }
  return key;  // Zwraca naciśnięty klawisz, lub 0, jeśli nie został naciśnięty żaden klawisz
}
