/*
 * szkic zero_wave
 * Głośnik z fotorezystorem - Arduino Zero
 */
const int outputPin = A0; // Słuchawki podłączone do analogowego pinu 0
const int sensorPin = A1; // Czujnik podłączony do analogowego pinu 1

const int low  = 200;
const int high = 800;

const int sampleCount = 16;  // Liczba nut na jeden cykl

const int minDur = 1000000/(sampleCount*500); // Okres równy 500 Hz
const int maxDur = 1000000/(sampleCount*50);  // Okres równy 50 Hz

// Tablica 16 nut dla jednego cyklu sinusoidy
static int sinewave[sampleCount] = { 
  0x1FF,0x2B6,0x355,0x3C7,0x3FF,0x3C7,0x355,0x2B6,
  0x1FF,0x148,0x0A9,0x037,0x000,0x037,0x0A9,0x148 
};
  
void setup()
{
  analogWriteResolution(10); // Rozdzielczość przetwornika cyfrowo-analogowego ustawiona na maksimum
}

void loop()
{
  int sensorReading = analogRead(sensorPin);    // Odczyt wejścia analogowego
  int duration = map(sensorReading, low, high, minDur, maxDur);
  duration = constrain(duration, minDur, maxDur);
  duration = constrain(duration, minDur, maxDur);

  for(int sample=0; sample < sampleCount; sample++) {
    analogWrite(outputPin, sinewave[sample]);
    delayMicroseconds(duration);
  }
}
