/*
 * szkic ReceiveBinaryData_P
 *
 * portIndex musi być równy numerowi portu podłączonego do Arduino
 */
import processing.serial.*;

Serial myPort;        // tworzenie obiektu klasy Serial

// UWAGA!
// W razie potrzeby zmień poniższą definicję podając poprawny numer portu.
short portIndex = 0;  // wybór portu szeregowego, 0 oznacza pierwszy port

char HEADER = 'H';
int value1, value2;         // dane otrzymane z pory szeregowego

void setup()
{
  size(600, 600);
  // Otwórz port, do którego podłączone jest Arduino.
  String portName = Serial.list()[portIndex];
  println(Serial.list());
  println(" Łączenie z -> " + portName);
  myPort = new Serial(this, portName, 9600);
}

void draw()
{
  // Odczytaj nagłówek i dwie binarne liczby całkowite po 16-bitów. 
  if ( myPort.available() >= 5)  // Jeśli jest dostępnych przynajmniej 5 bajtów,
  {
    if( myPort.read() == HEADER) // i jeśli jest to nagłówek,
    {
      value1 = myPort.read();                 // odczytaj najmniej znaczący bajt,
      value1 =  myPort.read() * 256 + value1; // dodaj najbardziej znaczący bajt,

      value2 = myPort.read();                 // odczytaj najmniej znaczący bajt,
      value2 =  myPort.read() * 256 + value2; // dodaj najbardziej znaczący bajt.

      println("Wiadomość odebrana: " + value1 + "," + value2);
    }
  }
  background(255);             // Ustaw białe tło.
  fill(0);                     // Ustaw wypełnienie na kolor czarny.

  // Narysuj prostokąt bazując na liczbach całkowitych odebranych z Arduino.
  rect(0, 0, value1,value2);
}
