/*
 * Szkic hardwarecounting
 *
 * Używa pinu 5 na ATmega 168/328
 */

const int hardwareCounterPin = 5;   // Pin wejścia przypisany do wewnętrznego licznika
const int ledPin             = LED_BUILTIN; 

const int samplePeriod = 1000; // Próbny okres podany w milisekundach
unsigned int count;

void setup()
{
  Serial.begin(9600);
  pinMode(ledPin,OUTPUT);
  // Konfiguracja sprzętowego licznika (szczegóły znajdziesz w dokumentacji ATmega)
  TCCR1A=0;        // Wyzerowanie rejestru sterującego licznikiem
}  

void loop()
{
  digitalWrite(ledPin, LOW);
  delay(samplePeriod);
  digitalWrite(ledPin, HIGH);  
  // początek liczenia
  bitSet(TCCR1B, CS12);  // Źródłem zegara licznika jest zewnętrzny pin
  bitSet(TCCR1B, CS11);  //  Zegar wzrostu sygnału
  delay(samplePeriod);
  // koniec liczenia
  TCCR1B = 0;           
  count = TCNT1;
  TCNT1 = 0;  // Wyzerowanie sprzętowego licznika
  if(count > 0)
     Serial.println(count);
}
