/*
 * Szkic thingtweets
 * Publikuje tweeta, gdy podłączony do pinu 2 przycisk zostanie wciśnięty
*/

// Usuń znaczniki komentarza tylko sprzed jednej z poniższych linijek
#include "USE_NINA.h"     // Dla płytek z Wi-Fi
//#include "USE_Ethernet.h" // Dla płytek z Ethernetem
//#include "USE_ESP8266.h"  // Dla płytek ESP8266


char *thingtweetAPIKey = "TwójkluczThingTweetAPI";  // Twój klucz ThingTweets API
char serverName[] = "api.thingspeak.com";

bool MsgSent = false;
const int btnPin = 2;

void setup()
{
  Serial.begin(9600);
  while (!Serial);
  if (!configureNetwork()) // Uruchomienie sieci
  {
    Serial.println("Błąd konfiguracji sieci");
    while (1)
      delay(0); // Zatrzymanie programu; ESP8266 nie lubi nieskończonych pętli bez funkcji delay
  }
  pinMode(btnPin, INPUT_PULLUP);
  delay(1000);
  Serial.println("Gotowe");
}

void loop()
{
  if (digitalRead(btnPin) == LOW) // Sprawdzanie czy przycisk został wciśnięty
  {
    if (MsgSent == false) // Sprawdzenie czy wiadomość została wysłana
    {
      MsgSent = sendMessage("Wcisnąłem przycisk #thingspeak");
      if (MsgSent)
        Serial.println("Tweet wysłany");
      else
        Serial.println("Wysłanie tweeta nieudane");
    }
  }
  else
  {
    MsgSent = false;  // Przycisk nie został wciśnięty
  }
  delay(100);
}

bool sendMessage(char *message)
{
  bool result = false;

  const int tagLen = 16; // Liczba znaków w znaczniku, który służącego służy  do sformułowania wiadomości
  int msgLen = strlen(message) + tagLen + strlen(thingtweetAPIKey);
  Serial.println("Łączenie ...");
  if (client.connect(serverName, 80) )
  {
    Serial.println("Wysyłanie żądania POST...");
    client.println("POST /apps/thingtweet/1/statuses/update HTTP/1.1");
    client.print("Host: "); client.println(serverName);
    client.println("Połączenie: zamknięte");
    client.println("Content-Type: application/x-www-form-urlencoded");
    client.print("Content-Length: "); client.println(msgLen);
    client.println();
    client.print("klucz_api=");          // Znacznik wiadomości
    client.print(thingtweetAPIKey);    // Klucz API
    client.print("&status=");          // Znacznik wiadomości
    client.print(message);             // Wiadomość
    client.println();
  }
  else 
  {
    Serial.println("Nie udało się nawiązać połączenia");
  }
  // Odpowiedź
  if (client.connected())
  {
    Serial.println("Połączono");
    if (client.find("HTTP/1.1") && client.find("200 OK") ) {
      result = true;
    }
    else
      Serial.println("Rozłączanie - brak 200 OK");
  }
  else
  {
    Serial.println("Rozłączono");
  }
  client.stop();
  client.flush();

  return result;
}
