/*
 * Szkic ethernet_nodhp
 * Łączy się z siecią bez DHCP, za pomocą adresu IP urządzenia podanego w kodzie na sztywno
 */

#include <SPI.h>
#include <Ethernet.h>

byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED }; // Adres MAC musi być unikatowy
IPAddress ip(192, 168, 1, 177); // To musi być prawidłowy adres dla Twojej sieci
char serverName[] = "archive.org";

EthernetClient client;

String request = "GET /advancedsearch.php?q=arduino&fl%5B%5D=description"
                 "&rows=1&sort%5B%5D=downloads+desc&output=csv#raw HTTP/1.0";

void setup()
{
  Serial.begin(9600);
  while(!Serial); // Linijka dla Leonardo i płytek 32-bitowych
  
  Ethernet.begin(mac, ip);
  delay(1000); // Sekunda przeznaczona na inicjalizację sprzętu Ethernet

  Serial.println("Łączenie z serwerem...");
  int ret = client.connect(serverName, 80); 
  if (ret == 1) 
  {
    Serial.println("Połączono");
    client.println(request);
    client.print("Host: "); client.println(serverName);
    client.println("Połączenie: zamknięte");
    client.println(); // Wysłanie pustej linijki na końcu, która jest wymagana przez HTTP
  } 
  else 
  {
    Serial.println("Błąd połączenia: ");
    Serial.print(ret, DEC);
  }
}

void loop()
{
  if (client.available()) 
  {
    char c = client.read();
    Serial.print(c);  // Przesłanie wszystkich odebranych danych do monitora portu szeregowego
  }
  if (!client.connected()) 
  {
    Serial.println();
    Serial.println("Rozłączanie...");
    client.stop();
    while(1); // Zatrzymanie programu
  }
}
