/*
 * sSzkic myDelay 
 * Miganie diodą LED z określoną częstotliwością
 */
const int ledPin =  LED_BUILTIN; // Numer pinu diody LED

int ledState = LOW;               // Zmienna ledState używana do usatawiania stanu diody LED
unsigned long previousMillis = 0; // Zmienna przechowują czas ostatniej zmiany stanu diody LED

void setup()
{
  pinMode(ledPin, OUTPUT);
  Serial.begin(9600);
}

void loop()
{
  if (myDelay(blink, 250))
  {
    Serial.println(millis() / 1000.0); // Wyświetlenie czasu, który upłynął (w ms)
  }
}

/*
 * Wykonanie określonej funkcji i zwrócenie wartości true, jeśli została wykonana
 */
bool myDelay(void (*func)(void), long interval)
{
  unsigned long currentMillis = millis();
  if (currentMillis - previousMillis >= interval)
  {
    // Zapisz czas, kiedy dioda LED mignęła ostatni raz
    previousMillis = currentMillis;
    func(); // wywołanie funkcji
    return true;
  }
  return false;
}

void blink()
{
  // Jeśli dioda LED jest wyłączona, to ją włącz, i na odwrót:
  if (ledState == LOW)
  {
    ledState = HIGH;
  }
  else
  {
    ledState = LOW;
  }
  digitalWrite(ledPin, ledState);
}
