/*
 * Szkic servo_sensor
 * Sterowanie serwomechanizmem za pomocą czujnika
 */

#include <Servo.h>

Servo myservo;  // Stworzenie obiektu Servo sterującego serwomechanizmem

int potpin = A0; // Pin analogowy, do którego podłączony jest potencjometr
int val;         // Zmienna przechowująca wartość odczytaną z analogowego pinu

void setup()
{
  myservo.attach(9); // Dołączenie do obiektu Servo pinu 9, do którego jest podłączone serwo
}

void loop()
{
  val = analogRead(potpin);            // Odczyt wartości potencjometru
  val = map(val, 0, 1023, 0, 180);     // Przeskalowanie odczytanej wartości dla serwa
  myservo.write(val);                  // Ustawienie pozycji na przeskalowaną wartość
  delay(15);                           // Oczekiwanie na ustawienie się serwa w zadanej pozycji
}
