/*
 * Szkic brushed_hbridge2
 * Sterowanie kierunkiem obrotu silników za pomocą poleceń odbieranych z portu szeregowego
 * + lub to ustawienie kierunku, inne znaki to zatrzymanie silnika
 */

const int in1Pin = 5;  // Piny wejścia mostku H
const int in2Pin = 4;

const int in3Pin = 3;  // Piny wejścia mostku H drugiego silnika
const int in4Pin = 2;

void setup()
{
  Serial.begin(9600);
  pinMode(in1Pin, OUTPUT);
  pinMode(in2Pin, OUTPUT);
  pinMode(in3Pin, OUTPUT);
  pinMode(in4Pin, OUTPUT);
  Serial.println("+ - to ustawienie kierunku, inne znaki to zatrzymanie silnika");
}

void loop()
{
  if ( Serial.available()) {
    char ch = Serial.read();
    if (ch == '+') 
    {
      Serial.println("zgodnie z kierunkiem wskazówek zegara");
      // pierwszy silnik
      digitalWrite(in1Pin,LOW);
      digitalWrite(in2Pin,HIGH);
      //drugi silnik
      digitalWrite(in3Pin,LOW);
      digitalWrite(in4Pin,HIGH);
    }
    else if (ch == '-')
    {
      Serial.println("przeciwnie do kierunku wskazówek zegara");
      digitalWrite(in1Pin,HIGH);
      digitalWrite(in2Pin,LOW);

      digitalWrite(in3Pin,HIGH);
      digitalWrite(in4Pin,LOW);
    }
    else if (ch != '\n' && ch != '\r') // Pominięcie znaku nowej linii lub powrotu karetki
    {
      Serial.print("Zatrzymanie silników");
      digitalWrite(in1Pin,LOW);
      digitalWrite(in2Pin,LOW);
      digitalWrite(in3Pin,LOW);
      digitalWrite(in4Pin,LOW);
    }
  }
}
