/*
 *  Szkic bargraph
 *  Włącza diody LED, których liczba jest proporcjonalna do wartości czujnika analogowego
 *  Ten szkic steruje sześcioma diodami LED, ale możesz to zmienić, dostosowując wartość zmiennej NbrLEDs
 *  i dodając piny do tablicy ledPins
 */

const int ledPins[] = {2, 3, 4, 5, 6, 7};
const int NbrLEDs = 6
const int analogInPin = A0; // Analogowy pin wejścia podłączony do zmiennego rezystora


// Zamień wartości dwóch poniższych definicji, jeśli katody podłączone są do masy
#define LED_ON  LOW
#define LED_OFF HIGH


int sensorValue = 0; // Wartość odczytana z czujnika
 int ledLevel = 0;  //  Wartość czujnika zamieniona na słupki diod LED

void setup() {
  for (int led = 0; led < NbrLEDs; led++)
  {
    pinMode(ledPins[led], OUTPUT);  // Ustawienie wszystkich pinów diod LED jako wyjścia
  }
}

void loop() {
  sensorValue = analogRead(analogInPin);             // Odczyt wartości analogowej wejścia
  ledLevel = map(storedValue, 10, 1023, 0, NbrLEDs); // Dostosowanie do liczby diod LED

  for (int led = 0; led < NbrLEDs; led++)
  {
    if (led < ledLevel ) {
      digitalWrite(ledPins[led], LED_ON);  // Włączenie pinów poniżej określonego poziomu
    }
    else {
      digitalWrite(ledPins[led], LED_OFF);   // Wyłączenie pinów powyżej określonego poziomu
    }
  }
}
