/*
 * Szkic RGB
 * Diody RGB LED sterowane za pomocą pinów wyjścia z funkcją PWM
*/

const int redPin   = 3;   // Pin dla każdej diody LED
const int greenPin = 5;
const int bluePin  = 6;
const bool invert = true; // Ustaw true dla diody ze wspólną anodą, a false w przypadku wspólnej katody

int color = 0; // Reprezentująca odcień wartość od 0 do 255 
int R, G, B;   // Składowe elementy koloru: czerwony, zielony, niebieski

void setup()
{
  // Piny sterowane przez analogWrite nie muszą być zadeklarowane jako wyjścia
}

void loop()
{
  int brightness = map(analogRead(A0),0,1023,0,255); // Pobranie jasność z czujnika

  hueToRGB(color, brightness); // Wywołanie funkcji zmieniającej odcień na RGB

  // Zapis wartości RGB na pinach
  analogWrite(redPin,   R);
  analogWrite(greenPin, G);
  analogWrite(bluePin,  B);

  color++; // Zwiększenie koloru
  if (color > 255)
    color = 0;
  delay(10);
}

// Funkcja zmieniająca kolor na jego elementy składowe: czerwony, zielony, niebieski
//
void hueToRGB(int hue, int brightness)
{
  unsigned int scaledHue = (hue * 6);

  // Segment od 0 do 5 na kole kolorów
  unsigned int segment = scaledHue / 256;

  // Pozycja w segmencie
  unsigned int segmentOffset = scaledHue - (segment * 256);

  unsigned int complement = 0;
  unsigned int prev = (brightness * ( 255 -  segmentOffset)) / 256;
  unsigned int next = (brightness *  segmentOffset) / 256;
  if (invert)
  {
    brightness = 255 - brightness;
    complement = 255;
    prev = 255 - prev;
    next = 255 - next;
  }

  switch (segment) {
    case 0:    // Czerwony
      R = brightness;
      G = next;
      B = complement;
      break;
    case 1:    // Żółty
      R = prev;
      G = brightness;
      B = complement;
      break;
    case 2:    // Zielony
      R = complement;
      G = brightness;
      B = next;
      break;
    case 3:    // Niebieskozielony
      R = complement;
      G = prev;
      B = brightness;
      break;
    case 4:    // Niebieski
      R = next;
      G = complement;
      B = brightness;
      break;
    case 5:    // Magenta
    default:
      R = brightness;
      G = complement;
      B = prev;
      break;
  }
}
