/* szkic mic_db
 * Płytka mikrofonu elektretowego firmy SparkFun została podłączona do analogowego pinu 0. 
 */

const int micPin = A0;            // mikrofon podłączony do pinu 0
const int ledPin = LED_BUILTIN;   // Kod będzie powodował miganie wbudowanej diody LED.
const int middleValue = 512;      // środek zakresu wartości analogowych
const int numberOfSamples = 128;  // liczba wykonywanych każdorazowo odczytów

int sample;                       // wartość odczytana z mikrofonu
long signal;                      // odczyt po usunięciu napięcia niezrównoważenia
long newReading;                  // średnia odczytów w dnaym obiegu pętli


long runningAverage = 0;          // średnia ruchoma obliczonych wartości
const int averagedOver = 16;      // jak bardzo nowe wartości wpływają na średnią ruchomą
                                  // większa wartość oznacza mniejszy wpływ

const int threshold = 30;        // Po przekroczeniu tej wartości, dioda LED zostaje zapalona.

void setup() 
{
  pinMode(ledPin, OUTPUT);
  Serial.begin(9600);
}

void loop() 
{
  long sumOfSquares = 0;
  for (int i=0; i<numberOfSamples; i++) { // Wykonaj wiele odczytów i wyciągnij z nich średnią.
    sample = analogRead(micPin);          // wykonanie pojedynczego odczytu
    signal = (sample - middleValue);      // obliczenie offsetu ze środkowej wartości
    signal *= signal;                     // podniesienie do kwadratu w celu uzyskania wartości dodatnich
    sumOfSquares += signal;               // dodanie do sumy
  }

  newReading = sqrt(sumOfSquares/numberOfSamples);

  // obliczenie średniej ruchomej
  runningAverage=(((averagedOver-1)*runningAverage)+newReading)/averagedOver;

  Serial.print("nowa:"); Serial.print(20*log10(newReading));
  Serial.print(",");
  Serial.print("ruchoma:"); Serial.println(20*log10(runningAverage));

  if (runningAverage>threshold){         // Czy średnia jest wyższa od wartości progowej ?
    digitalWrite(ledPin, HIGH);          // Jeśli tak, włącz diodę LED, 
  }else{
    digitalWrite(ledPin, LOW);           // jeśli nie, zgaś diodę LED.
  }

}
