/* Szkic hc_sr04
 * Czujnik HC-SR04
 * Wyświetla odległość i zmienia częstotliwość migania diody LED,
 * w zależności od odległości obiektu od czujnika HC-SR04
 */

const int trigPin = 5; // Pin wysyłający dźwięk
const int echoPin = 6; // Pin odbierający odbity dźwięk 
const int ledPin  = LED_BUILTIN; // Pin diody LED

void setup()
{
  Serial.begin(9600);
  pinMode(ledPin, OUTPUT);
  pinMode(trigPin, OUTPUT);
  pinMode(echoPin, INPUT);
}

void loop()
{
  int cm = calculateDistance(trigPin);
  Serial.println(cm);

  digitalWrite(ledPin, HIGH);
  delay(cm * 10); // Każdy centymetr dodaje 10 ms do opóźnienia
  digitalWrite(ledPin, LOW);
  delay(cm * 10);
}

int calculateDistance(int trigPin)
{
  long duration; // Zmienna przechowująca długość impulsu

  digitalWrite(trigPin, LOW); 
  delayMicroseconds(2);  // Pozostaje w stanie niskim przez 2μs, aby upewnić się, że impuls jest czysty
  digitalWrite(trigPin, HIGH);
  delayMicroseconds(10); // Wysyła impuls przez 10μs, aby upewnić się, że jest niezakłócony
  digitalWrite(trigPin, LOW);

  // Odczyt długości odbitego impulsu
  duration = pulseIn(echoPin, HIGH);

  // Zamiana czasu na odległość
  return duration / 29 / 2;
}
