/*
 * Szkic multiplexer
 * Odczyt ośmiu wartości analogowych za pomocą multipleksera 4051 i jednego analogowego pinu wejścia
 */

// Tablica pinów używana do wybierania kolejnych wejść
const int select[] = {2,3,4}; // Piny podłączone do wybierających linii wejścia 4051 
const int analogPin = A0;      // Pin analogowy podłączony do wyjścia multipleksera

// Funkcja zwracająca wartość analogową dla danego kanału
int getValue(int channel)
{
   // Ustawienie pinów wybierających jako HIGH i LOW tak, aby pasowały do wartości binarnej kanału
   for(int bit = 0; bit < 3; bit++)
   {
      int pin = select[bit]; // Pin podłączony do bitu wybierającego multipleksera
      int isBitSet =  bitRead(channel, bit); // Wartość true, jeśli dany bit jest ustawiony w kanale
      digitalWrite(pin, isBitSet);
   }
   return analogRead(analogPin);
}

void setup()
{
  for(int bit = 0; bit < 3; bit++)
  {
    pinMode(select[bit], OUTPUT);  // Wstawienie trzech pinów jako wyjścia
  }
  Serial.begin(9600);
}
void loop () {
  //  Wyświetlaj wartość każdego kanału raz na sekundę
  for(int channel = 0; channel < 8; channel++)
  {
     int value = getValue(channel);
     Serial.print("Kanał ");
     Serial.print(channel);
     Serial.print(" = ");
     Serial.println(value);
  }
  delay (1000);
}
