/*
 * Szkic debounce
 * Podłączony do pinu przełącznik zapala wbudowaną diodę LED
 * Logika rozwiązująca problem drgających styków eliminuje błędne odczyty
 */

const int inputPin = 2;        // Numer pinu wejścia
const int debounceDelay = 10;  // Liczba iteracji, która musi być wykonana, aby ustabilizować pin
bool last_button_state = LOW;  // Ostatni stan przycisku
int ledState = LOW;            // Włączone lub wyłączone (HIGH lub LOW)

// Funkcja debounce zwraca stan, gdy styki są stabilne
bool debounce(int pin)
{
  bool state;
  bool previousState;

  previousState = digitalRead(pin);          // Zapisanie stanu przycisku
  for(int counter=0; counter < debounceDelay; counter++)
  {
      delay(1);                  // 1-milisekundowa pauza
      state = digitalRead(pin);  // Odczyt pinu
      if( state != previousState)
      {
         counter = 0; // Zerowanie licznika (counter), jeśli stan się zmienia
         previousState = state;  // Zapisanie aktualnego stanu
      }
  }
  // Zwróć wartość, jeśli jest taka sama przy każdym obiegu pętli
  return state;
}

void setup()
{
  pinMode(inputPin, INPUT);
  pinMode(LED_BUILTIN, OUTPUT);
}

void loop()
{
  bool button_state = debounce(inputPin);

  // Jeśli stan przycisku się zmienił i przycisk został naciśnięty,
  if (last_button_state != button_state && button_state == HIGH) {
    // zmień stan diody LED
    ledState = !ledState;
    digitalWrite(LED_BUILTIN, ledState);
  }
  last_button_state = button_state;
}
