/*
 * Szkic RespondingToChanges
 * Miga diodą wskazując niski poziom napięcia.
 */

long batteryFull       = 1500;  // Liczba miliwoltów w pełni naładowanej baterii
long warningThreshold  = 1200;  // Poziom ostrzegawczy (w miliwoltach) — dioda LED miga
long criticalThreshold = 1000;  // Poziom krytyczny (w miliwoltach) — dioda LED pozostaje zapalona

const int batteryPin = A0;
const int ledPin = LED_BUILTIN;

void setup()
{
   pinMode(ledPin, OUTPUT);
}

void loop()
{
  int val = analogRead(batteryPin);    // Odczyt wartości z czujnika
  int mv = map(val, 0, 1023, 0, 5000); 
  if(mv < criticalThreshold) {
    digitalWrite(ledPin, HIGH);
  }
  else if (mv < warningThreshold) {
    int blinkDelay = map(mv, criticalThreshold, batteryFull, 0, 250);
    flash(blinkDelay);
  }
  else
  {
    digitalWrite(ledPin, LOW);
  }
  delay(1);
}

// Funkcja, która sprawia, że dioda LED miga z określoną częstotliwością
void flash(int blinkDelay)
{
  digitalWrite(ledPin, HIGH);
  delay(blinkDelay);
  digitalWrite(ledPin, LOW);
  delay(blinkDelay);
}
