/*
 Szkic conditional_pot_debug
 Miga diodą LED z częstotliwością zależną od ustawienia potencjometru
 Jeśli jest zdefiniowana wartość DEBUG, szkic używa portu szeregowego do wyświetlania informacji przydanych podczas debugowania
 */

const int potPin = 0;    // Pin wejścia, do którego podłączony jest potencjometr
const int ledPin = 13;   // Pin, do którego podłączona jest dioda LED
int val = 0;             // Zmienna przechowująca wartości odczytane z czujnika

#define DEBUG

void setup()
{
  Serial.begin(9600);
  pinMode(ledPin, OUTPUT);     // Ustawienie ledPin jako wyjścia
}

void loop() {
  val = analogRead(potPin);    // Odczyt napięcia potencjometru
  digitalWrite(ledPin, HIGH);  // Włączenie diody LED
  delay(val);                  // Częstotliwość określona wartością potencjometru
  digitalWrite(ledPin, LOW);   // Wyłączenie diody LED
  delay(val);                  // Wyłączenie diody LED na tak długo, jak była włączona
#if defined DEBUG
  Serial.println(val);
#endif
}
