/*
 * Szkic web_server_post
 * Włącza i wyłącza pin za pomocą formularza HTML
 */

// Usuń znaczniki komentarza tylko sprzed jednej z poniższych linijek
#include "USE_NINA.h"     // Dla płytek z Wi-Fi
//#include "USE_Ethernet.h" // Dla płytek z Ethernetem
//#include "USE_ESP8266.h"  // Dla płytek ESP8266

const int MAX_PAGE_NAME_LEN = 11;  // Maksymalna liczba znaków w nazwie strony
char buffer[MAX_PAGE_NAME_LEN+1];  // Nazwa strony + końcowy null

void setup() 
{
  Serial.begin(9600);
 
  if (!configureNetwork()) // Uruchomienie sieci
  {
    Serial.println("Błąd konfiguracji sieci");
    while(1)
      delay(0); // Zatrzymanie programu; ESP8266 nie lubi nieskończonych pętli bez funkcji delay
  }
  server.begin();
}

#define MSG_DELAY 10000
void loop() {
  static unsigned long nextMsgTime = 0;
  if (millis() > nextMsgTime)
  {
    Serial.print("Odwiedź http://");
    Serial.println(getIP());
    nextMsgTime = millis() + MSG_DELAY;
  }

  maintain(); // Utrzymanie dzierżawy DHCP, jeśli jest to konieczne

  client = server.available();
  if (client) 
  {
    int type = 0;
    while (client.connected()) 
    {
      if (client.available()) 
      {
        // GET, POST, lub HEAD
        memset(buffer,0, sizeof(buffer)); // Wyczyszczenie buforu

        if(client.readBytesUntil('/', buffer,sizeof(buffer)))
        { 
          Serial.println(buffer);
          if(strcmp(buffer,"POST ") == 0)
          {
            client.find("\r\n\r\n"); // Przejdź do treści

            // Wyszukanie symboli rozpoczynających się słowem "pin" i zatrzymanie na pierwszej pustej linii
            // Wymagany format parametrów POST to pinDx=Y,
            // gdzie x to numer pinu, a Y to 0 dla LOW i 1 dla HIGH
            while(client.findUntil("pinD", "\r\n"))
            {
              int pin = client.parseInt();       // Numer pinu
              int val = client.parseInt();       // 0 lub 1
              pinMode(pin, OUTPUT);
              digitalWrite(pin, val);
            }
          }
          else // Prawdopodobnie GET
          { 
            if (client.find("favicon.ico")) // Wysłanie 404 dla favikon
              sendHeader("404 strona nie istnieje", "Strona nie istnieje");
          }
          sendHeader("200 OK", "Przykład POST");

          //Utworzenie przycisku HTML służącego do wyłączania pinu 8
          client.println("<h2>Przyciski służące do włączania i wyłączania pinu 8</h2>");
          client.print(
            "<form action='/' method='POST'><p><input type='hidden' name='pinD8'");
          client.println(" value='0'><input type='submit' value='Wyłącz'/></form>");

          //Utworzenie przycisku HTML służącego do włączania pinu 8
          client.print(
            "<form action='/' method='POST'><p><input type='hidden' name='pinD8'");
          client.print(" value='1'><input type='submit' value='Włącz'/></form>");
          client.println("</body></html>");
          client.stop();
        }
        break; // Wyjście z pętli while
      }
    }
    // Czas dla przeglądarki na odebranie danych
    delay(100);
    client.stop();
  }
}
void sendHeader(char *code, char *title)
{
  // Wysłanie standardowego nagłówka odpowiedzi HTTP
  client.print("HTTP/1.1 "); client.println(code);
  client.println("Typ zawartości: text/html");
  client.println();
  client.print("<html><head><title>");
  client.print(title);
  client.println("</title><body>");
}
