/*
 * Szkic nunchuck
 * Wysyła dane do Processing, aby rysowała się linia odwzorowująca ruch kontrolera
 */

#include <Wire.h> // dołączenie biblioteki Wire

const int vccPin = A3;   // +V dostarczane przez 17
const int gndPin = A2;   // Masa dostarczana przez 16

const int dataLength = 6;          // Liczba żądanych bajtów
static byte rawData[dataLength];   // Tablica przechowująca dane z kontrolera

enum nunchuckItems { joyX, joyY, accelX, accelY, accelZ, btnZ, btnC };

void setup() {  
  pinMode(gndPin, OUTPUT); // Ustawienie odpowiednich stanów na pinach zasilania
  pinMode(vccPin, OUTPUT);
  digitalWrite(gndPin, LOW);
  digitalWrite(vccPin, HIGH);
  delay(100);  // Czekanie na ustabilizowanie się pinów

  Serial.begin(9600);
  Serial.println("OK");
  nunchuckInit();
  Serial.println("OK");
}

void loop(){
  nunchuckRead();
  int acceleration = getValue(accelX);
  if((acceleration >= 75) && (acceleration <= 185))
  {
    //skalowanie wartości z zakresu od 0 do 63, na zakres od 75 do 185
    byte  x = map(acceleration, 75, 185, 0, 63);
    Serial.write(x);
  delay(20); // Czas w milisekundach pomiędzy kolejnymi rysowaniami
  }
}

void nunchuckInit(){
  Wire.begin();                // Połączenie magistrali I2C jako urządzenie nadrzędnego
  Wire.beginTransmission(0x52);// Przesyłanie do urządzenia o adresie 0x52
  Wire.write((byte)0x40);      // Wysłanie adresu pamięci
  Wire.write((byte)0x00);      // Wysłanie zera  
  Wire.endTransmission();      // Koniec przesyłania
}

// Wysłanie zapytania o dane do kontrolera
static void nunchuckRequest(){
  Wire.beginTransmission(0x52);// Przesyłanie do urządzenia o adresie 0x52
  Wire.write((byte)0x00);      // Wysłanie 1 bajta
  Wire.endTransmission();      // Koniec przesyłania
}

// Odbieranie danych z kontrolera: 
// Zwraca true, jeśli odczyt przebiegł pomyślnie, w przeciwnym wypadku, zwraca false
bool nunchuckRead(){
  int cnt=0;
  Wire.requestFrom (0x52, dataLength); // Żądanie danych z kontrolera
  while (Wire.available ()) {
    rawData[cnt] = nunchuckDecode(Wire.read());
    cnt++;
  }
  nunchuckRequest();  // Wysłanie żądania kolejnego zestawu danych
  if (cnt >= dataLength) 
    return true;     // Sukces, jeśli zostało odebrane wszystkie 6 bajtów
  else
    return false;    //Niepowodzenie
}

// Kodowanie danych do formatu akceptowanego przez większość sterowników kontrolera Wii
static char nunchuckDecode (byte x) {
  return (x ^ 0x17) + 0x17;
}

int getValue(int item){
  if (item <= accelZ)
    return (int)rawData[item]; 
  else if (item  == btnZ) 
    return bitRead(rawData[5], 0) ? 0: 1;
  else if (item  == btnC) 
    return bitRead(rawData[5], 1) ? 0: 1;    
}
