/*
 * Szkic eeprom
 * Odczytuje dane i zapisuje na 24LC128
 */

#include <Wire.h>

const byte EEPROM_ID = 0x50; // Adres I2C dla 24LC128 EEPROM

// Pierwszy, czytelny dla człowieka znak '!' ma numer 33:
int thisByte = 33;

void setup()
{
  Serial.begin(9600);
  while(!Serial); // Wymagane dla Leonardo i większość płytek bazujących na ARM
  Wire.begin();

  Serial.println("Zapis 1024 bajtów na EEPROM");
  for (int i=0; i < 1024; i++)
  {
    I2CEEPROM_Write(i, thisByte);
    // Przejście do kolejnego znaku
    thisByte++;
    if (thisByte == 126)   // Można również użyć (thisByte == '~')
      thisByte = 33;     // Rozpoczęcie od nowa
  }

  Serial.println("Odczyt 1024 bajtów z EEPROM");
  int thisByte = 33;
  for (int i=0; i < 1024; i++)
  {
    char c = I2CEEPROM_Read(i);
    if(c != thisByte)
    {
      Serial.println("Błąd odczytu");
      break;
    }
    else
    {
      Serial.print(c);
    }
    thisByte++;
    if(thisByte == 126)
    {
      Serial.println();
      thisByte = 33;     // Rozpoczęcie od nowa w nowej linijce
    }
  }
  Serial.println();
  Serial.println("Gotowe");
}

void loop()
{

}

// Ta funkcja jest podobna do funkcji Arduino EEPROM.write()
void I2CEEPROM_Write(unsigned int address, byte data)
{
  Wire.beginTransmission(EEPROM_ID);
  Wire.write((int)highByte(address));
  Wire.write((int)lowByte(address));
  Wire.write(data);
  Wire.endTransmission();

  delay(5); // Czekanie, aż I2C EEPROM zakończy proces zapisu
}

// Ta funkcja jest podobna do EEPROM.read()
byte I2CEEPROM_Read(unsigned int address )
{
  byte data;

  Wire.beginTransmission(EEPROM_ID);
  Wire.write((int)highByte(address));
  Wire.write((int)lowByte(address));
  Wire.endTransmission();

  Wire.requestFrom(EEPROM_ID,(byte)1);
  while(Wire.available() == 0) // Czekanie na dane
    ;
  data = Wire.read();
  return data;
}
