#include <TimeLib.h>

const int  potPin = A0;    // potencjometr do określania kierunku i szybkości
const int  buttonPin = 2;  // przycisk ustawiający czas

unsigned long prevtime;   // zmienna przechowująca informację, kiedy ostatni raz czas był wyświetlany

void setup()
{
  digitalWrite(buttonPin, HIGH);  // włączenie rezystorów podciągających
  setTime(12,0,0,1,1,2020); // ustawienie czasu początkowego na 12:00,  1 stycznia 2020
  Serial.begin(9600);
}

void loop()
{
  prevtime = now();   // zapisanie czasu
  while( prevtime == now() )    // pętla wykoująca się dopóki nie zmieni się sekunda
  {
    // Czy został wciśniety jeden z przycisków ustawiający czas, podczas czekania na kolejną sekundę?
    if(checkSetTime())
      prevtime = now(); //  Jeśli tak, czas się zmienił więc go zresetuj.
  }
  digitalClockDisplay();
}

// funkcje sprawdzające czy czas powinien być zmieniony
// Funkcja zwraca prawdę, jeśli czas się zmienił.
bool checkSetTime()
{
  int value;  // wartość odczytana z potencjometru
  int step;   // liczba sekund do zmiany (odjęcie lub dodanie)
  bool isTimeAdjusted = false;  // ustawienie na true, jeśli czas został zmieniony

  while(digitalRead(buttonPin)== LOW)
  {
    // Po wciśnięciu przycisku
    value = analogRead(potPin);  // odczytaj wartość potencjometru
    step = map(value, 0,1023, 10, -10);  // skaluj wartość do ustalonego zakresu
    if( step != 0)
    {
      adjustTime(step);
      isTimeAdjusted = true; // poinformowanie użytkownika, że czas został zmieniony
      digitalClockDisplay(); // aktualizacja zegara   
      delay(100);
    }
  }
  return isTimeAdjusted;
}

// dodanie początkowych zer do cyfr
String padDigits(int digit)
{
  String str = String("0") + digit; // dodanie zera przez cyfrą
  return str.substring(str.length() - 2); // usunięcie wszystkich znaków, oprócz dwóch ostatnich
}

void digitalClockDisplay(){
  String timestr = String(hour()) + ":" + padDigits(minute()) +
                   ":" + padDigits(second());
  Serial.println(timestr);

  String datestr = String(dayStr(weekday())) + ", " + 
                   String(monthShortStr(month())) + " " + String(year());
  Serial.println(datestr);
}
