const int speakerPin = 9;    // pin głośnika
const int pitchPin = A0;     // analogowy pin potencjometru, który określa częstotliwość dźwięku
const int durationPin = A1;  // wejście określające długość dźwięku
const int inputPin = 8;

void setup()
{
  pinMode(inputPin, INPUT_PULLUP);
}

void loop()
{
  int sensor0Reading = analogRead(pitchPin);    // odczyt wartości wejściowej w celu ustawienia częstotliwości
  int sensor1Reading = analogRead(durationPin); // odczyt wartości wejściowej w celu ustawienia długości

  // skalowanie odczytów analogowych
  int frequency  = map(sensor0Reading, 0, 1023, 100, 5000); // częstotliwość od 100Hz do 5kHz
  int duration = map(sensor1Reading, 0, 1023, 100, 1000);   // długość od 0,1 do 1 sekundy
  if (digitalRead(inputPin) == LOW)  // odczyt wartości wejściowej
  {
    tone(speakerPin, frequency, duration); // odtworzenie dźwięku
    delay(duration); //Poczekaj, aż dźwięk się skończy.
  }
}
