/*
 * Szkic stepper_easydriver
 * Silnik krokowy sterowany za pomocą poleceń z portu szeregowego
 * Znak '+' lub '-' poprzedzony wartością liczbową obraca silnikiem
 * Znak 's' poprzedzony wartością liczbową zmienia prędkość
 */

const int dirPin  = 2;
const int stepPin = 3;
const int enPin   = 4;

int speed = 100; // Prędkość wyrażona w liczbie kroków na sekundę
int steps = 0; // Liczba kroków do wykonania
long last_step = millis();
long timeout = 30 * 1000; // Wyłączenie silnika po 30 s braku aktywności 


void setup()
{
  pinMode(dirPin, OUTPUT);
  pinMode(stepPin, OUTPUT);
  pinMode(enPin, OUTPUT);
  Serial.begin(9600);
}

void loop()
{
  if (millis() > last_step + timeout)
  {
    digitalWrite(enPin,HIGH); // Wyłączenie silnika
  }  

  if ( Serial.available()) 
  {
    char ch = Serial.read();

    if(isDigit(ch)) // Czy zmienna ch jest liczbą?
    {
      steps = steps * 10 + ch - '0'; //Jeżeli tak, sumuj wartości
    }
    else if(ch == '+')
    {
      step(steps);
      steps = 0;
    }
    else if(ch == '-')
    {
      step(-steps);
      steps = 0;
    }
    else if(ch == 's')
    {
      speed = steps;
      Serial.print("Ustawienie prędkości na "); Serial.println(steps);
      steps = 0;
    }
  }
}

void step(int steps)
{
  int stepDelay = 1000 / speed; //Opóźnienie w ms dla prędkości określonej w krokach na sekundę
  int stepsLeft;

  digitalWrite(enPin,LOW); // Włączenie silnika
  last_step = millis();

  // Określenie kierunku obrotu silnika bazując na wartości zmiennej steps_to_mode (+ lub -)
  if (steps > 0)
  {
    digitalWrite(dirPin, HIGH);
    stepsLeft = steps;
  }
  if (steps < 0)
  {
    digitalWrite(dirPin, LOW);
    stepsLeft = -steps;
  }
  // Po każdym wykonanym kroku, zmniejszenie o 1 wartości zmiennej stepsLeft przechowującej liczbę kroków do wykonania
  while(stepsLeft > 0)
  {
    digitalWrite(stepPin,HIGH);
    delayMicroseconds(1);
    digitalWrite(stepPin,LOW);
    delay(stepDelay);
    stepsLeft--; // Zmniejszenie o 1 wartości zmiennej stepsLeft
  }
}
