/*
 * Szkic simple_brushed
 * Regulacja prędkości silnika za pomocą poleceń odebranych przez port szeregowy 
 * Cyfry od '0' do '9' są obsługiwane, gdzie '0' oznacza wyłączony silnik, a '9' maksymalną prędkość
 */

const int motorPin = 3; // Sterownik silnika podłączony do pinu 3

void setup()
{
  Serial.begin(9600);
}

void loop()
{
  if ( Serial.available()) {
    char ch = Serial.read();

    if(isDigit(ch))  // Czy zmienna ch to liczba?
    {
      int speed = map(ch, '0', '9', 0, 255);
      analogWrite(motorPin, speed);
      Serial.println(speed);
    }
    else
    {
      Serial.print("Błędny znak ");
      Serial.println(ch);
    }
  }
}
