/*
 * Szkic brushed_arduino_motor_shield
 * Wykorzystuje czujniki światła do sterowania kierunkiem obrotów silników
 * Robot porusza się w stronę światła
 */

int leftPins[]  = {3,12};   // Jeden pin dla PWM, jeden dla kierunku obrotu silników
int rightPins[] = {11,13};

const int MIN_PWM        = 64;  // Zakres od 0 do MAX_PWM
const int MAX_PWM        = 128; // Zakres od około 50 do 255
const int leftSensorPin  = A2;  // Analogowe piny czujników
const int rightSensorPin = A3;

int sensorThreshold = 0; // Wartość progowa poziomu światła, po której osiągnięciu silnik się porusza

void setup()
{
  pinMode(leftPins[1], OUTPUT);
  pinMode(rightPins[1], OUTPUT);
}

void loop()
{
  int leftVal = analogRead(leftSensorPin);
  int rightVal = analogRead(rightSensorPin);
  if(sensorThreshold == 0) // Czy czujniki zostały skalibrowane?
  {  
     // Jeśli nie, skalibruj czujniki do wartości zbliżonej do średniej jasności otoczenia
     sensorThreshold = ((leftVal + rightVal) / 2) + 100 ; 
  }
  
  if( leftVal > sensorThreshold || rightVal > sensorThreshold)
  {
    // Jeśli jest odpowiednio dużo światła, robot jedzie
    setSpeed(rightPins, map(rightVal,0,1023, MIN_PWM, MAX_PWM));
    setSpeed(leftPins,  map(leftVal, 0,1023, MIN_PWM, MAX_PWM));
  }
}

void setSpeed(int pins[], int speed )
{
  if(speed < 0)
  {
    digitalWrite(pins[1], HIGH);
    speed = -speed;
  }
  else
  {
    digitalWrite(pins[1], LOW);
  }
  analogWrite(pins[0], speed);
}
