/*
 * Szkic brushed_adafruit_motorshield
 * Wykorzystuje czujniki światła do sterowania kierunkiem obrotów silników
 * Robot porusza się w stronę światła
 */

#include <Wire.h>
#include <Adafruit_MotorShield.h> // biblioteka nakładki Adafruit Motor Shield

// stworzenie obiektu nakładki
Adafruit_MotorShield AFMS = Adafruit_MotorShield(); 

Adafruit_DCMotor *leftMotor = AFMS.getMotor(1);
Adafruit_DCMotor *rightMotor = AFMS.getMotor(2);

const int MIN_PWM        = 64;  // Zakres od 0 do MAX_PWM
const int MAX_PWM        = 128; // Zakres od około 50 do 255
const int leftSensorPin  = A0;  // Analogowe piny czujników
const int rightSensorPin = A1;

int sensorThreshold = 0;  // Wartość progowa poziomu światła, po której osiągnięciu silnik się porusza

void setup()
{
  AFMS.begin();  // Inicjalizacja z domyślną częstotliwością 1,6 kHz
}

void loop()
{
  int leftVal  = analogRead(leftSensorPin);
  int rightVal = analogRead(rightSensorPin);
 
  if(sensorThreshold == 0) // Czy czujniki zostały skalibrowane?
  {  
    // Jeśli nie, skalibruj czujniki do wartości zbliżonej do średniej jasności otoczenia  
    sensorThreshold = ((leftVal + rightVal) / 2) + 100 ;  
  }   
 
  if( leftVal > sensorThreshold || rightVal > sensorThreshold)  
  {   
    // Jeśli jest odpowiednio dużo światła, robot jedzie
    setSpeed(rightMotor, map(rightVal,0,1023, MIN_PWM, MAX_PWM));
    setSpeed(leftMotor,  map(leftVal ,0,1023, MIN_PWM, MAX_PWM));
  }
}

void setSpeed(Adafruit_DCMotor *motor, int speed )
{
  if(speed < 0)
  {
    motor->run(BACKWARD);
    speed = -speed;
  }
  else
  {
    motor->run(FORWARD);
  }
  motor->setSpeed(speed);
}
