/*
 Szkic SwitchTime
 Licznik, który odlicza w dół z prędkością 0,1 s i po dojściu do zera zapala diodę LED
 Przyciskanie przycisku zwiększa wartość początkową;
 im dłużej przycisk jest przytrzymywany, tym szybciej zwiększana jest wartość początkowa

 */
const int ledPin = LED_BUILTIN;        // Numer pinu wyjścia
const int inPin = 2;                   // Numer pinu wejścia

const int debounceTime = 20;           // Podany w milisekundach wymagany czas, aby przycisk się ustabilizował
const int fastIncrement = 1000;        // Wartość (milisekundy), po której wartość początkowa ma być szybciej zwiększana
const int veryFastIncrement = 4000;    // Wartość (milisekundy), po której wartość początkowa ma być szybciej zwiększana jeszcze szybciej

int count = 0;                         // zmienna count, dekrementowana co 0,1 s,, aż do osiągnięcia wartości 0

void setup()
{
  pinMode(inPin, INPUT_PULLUP);
  pinMode(ledPin, OUTPUT);
  Serial.begin(9600);
}

void loop()
{
  int duration = switchTime();
  if(duration > veryFastIncrement)
  {
    count = count + 10;
  }
  else if (duration > fastIncrement)
  {
    count = count + 4;    
  }
  else if (duration > debounceTime)
  {
    count = count + 1;
  }
  else
  {
    // Przycisk nie jest wciśnięty, obsługa zmiennej count
    if( count == 0) 
    {
      digitalWrite(ledPin, HIGH);  // Zapal diodę LED, jeśli zmienna count jest równa 0.
    }
    else
    {
      digitalWrite(ledPin, LOW);   // Zgaś diodę LED, jeśli zmienna count nie jest równa 0
      count = count - 1;           // i zmniejsz jej wartość o 1
    }
  }
  Serial.println(count);
  delay(100);
}

// Zwróć czas (w milisekundach) wciskania przycisku (wartość na pinie równa LOW)
long switchTime()
{
  // Poniższe zmienne są statyczne - w Omówieniu znajdziesz wyjaśnienie
  static unsigned long startTime = 0; // Początek  - została wykryta zmiana stanu przycisku.
  static bool state;                  // Aktualny stan przycisku

  if(digitalRead(inPin) != state) // Czy przycisk zmienił stan?
  {
    state = ! state;       // Tak, zmień stan na przeciwny
    startTime = millis();  // Zmienna przechowująca upływający  czas
  }
  if(state == LOW)
  {
    return millis() - startTime;   // Przycisk nie jest wciśnięty, zwróć czas (w milisekundach)
  }
  else
  {
    return 0; // Zwróć 0, jeśli przycisk nie jest wciśnięty (HIGH)
  }
}
