/*
 * Szkic case_statement
 * Przykład z wyrażeniem switch służącym do sprawdzania znaków odebranych przez połączenie szeregowe
 *
 * Wysłanie znaku 1 powoduje pojedyncze mignięcie diodą, znaku 2 skutkuje podwójnym mignięciem
 * Wysłanie znaku + zapala diodę LED, a wysłanie znaku – ją gasi
 * Każdy inny znak powoduje wyświetlenie się wiadomości w monitorze portu szeregowego

 */

void setup()
{
  Serial.begin(9600); // Inicjalizacja portu szeregowego nadającego i odbierającego z prędkością 9600

  pinMode(LED_BUILTIN, OUTPUT);
}

void loop()
{
  if ( Serial.available()) // Sprawdź czy został nadany choć jeden znak

  {
    char ch = Serial.read();
    switch(ch)
    {
    case '1':
      blink();
      break;
    case '2':
      blink();
      blink();
      break;
    case '+':
      digitalWrite(LED_BUILTIN, HIGH);
      break;
    case '-':
      digitalWrite(LED_BUILTIN, LOW);
      break;
    case '\n': // Ignorowany znak nowej linii
      break;
    case '\r': // Ignorowany znak powrotu karetki
      break;
    default :
      Serial.print(ch);
      Serial.println(" został otrzymany, ale nie jest na liście obsługiwanych znaków.");
      break;
    }
  }
}

void blink()
{
  digitalWrite(LED_BUILTIN, HIGH);
  delay(500);
  digitalWrite(LED_BUILTIN, LOW);
  delay(500);
}
