/*
 * Szkic samplingrate
 * Zwiększa częstotliwość odczytów dla funkcji analogRead
 */
const int sensorPin = 0;             // Pin, do którego podłączony jest odbiornik
const int numberOfEntries = 100;

unsigned long microseconds;
unsigned long duration;

int results[numberOfEntries];

void setup()
{
  Serial.begin(9600);
  while(!Serial); // Linijka wymagana dla Leonardo

  // Standardowa wydajność analogRead (dzielnik częstotliwości = 128)
  microseconds = micros();
  for(int i = 0; i < numberOfEntries; i++)
  {
    results[i] = analogRead(sensorPin);
  }
  duration = micros() - microseconds;
  Serial.print(numberOfEntries);
  Serial.print(" odczytów zajęło ");
  Serial.println(duration);

  // Wysoka prędkość zegara (dzielnik częstotliwości = 16)
  bitClear(ADCSRA,ADPS0);
  bitClear(ADCSRA,ADPS1);
  bitSet(ADCSRA,ADPS2);
  microseconds = micros();
  for(int i = 0; i < numberOfEntries; i++)
  {
    results[i] = analogRead(sensorPin);
  }
  duration = micros() - microseconds;
  Serial.print(numberOfEntries);
  Serial.print(" odczytów zajęło ");
  Serial.println(duration);
}

void loop()
{
}
