/*
 * Szkic mouse
 * Używa biblioteki Mouse, aby naśladować myszkę na USB
 */

#include "Mouse.h"

const int buttonPin = 2; // Lewy przycisk myszki
const int potXPin = A4;   // Piny analogowe, do których podłączone są potencjometry
const int potYPin = A5;

int last_x = 0;
int last_y = 0;

void setup()
{
  Serial.begin(9600);
  pinMode(buttonPin, INPUT_PULLUP);

  // Pobierz początkową pozycję potencjometrów; wartości mieszczą się w zakresie od –127 do 127
  last_x = (512 - (int) analogRead(potXPin)) / 4;
  last_y = (512 - (int) analogRead(potYPin)) / 4;
  
  Mouse.begin();
}

void loop()
{
  // Pobierz obecną pozycję
  int x = (512 - (int) analogRead(potXPin)) / 4;
  int y = (512 - (int) analogRead(potYPin)) / 4;

  Serial.print("ostatni_x: "); Serial.println(last_x);
  Serial.print("ostatni_y: "); Serial.println(last_y);
  Serial.print("x: "); Serial.println(x);
  Serial.print("y: "); Serial.println(y);
  
  // Obliczenie ruchu na podstawie obecnej i ostatniej wartości potencjometru
  int xDistance = last_x - x;
  int yDistance = last_y - y;

  // Aktualizacja ostatniej pozycji potencjometru
  last_x = x;
  last_y = y;

  // Jeśli ruch wzdłuż osi x lub y jest większy niż 3, rusz:
  if (abs(xDistance) > 3 || abs(yDistance) > 3) 
  {
    Serial.print("ruch wzdłuż osi x: "); Serial.println(xDistance);
    Serial.print("ruch wzdłuż osi y: "); Serial.println(yDistance);
    Mouse.move(xDistance, yDistance, 0);
  }

  // Jeśli został naciśnięty przycisk myszy,
  if (digitalRead(buttonPin) == LOW) 
  {
    if (!Mouse.isPressed(MOUSE_LEFT)) 
    {
      Mouse.press(MOUSE_LEFT); // kliknij
    }
  }
  else 
  {
     if (Mouse.isPressed(MOUSE_LEFT)) 
    {
      Mouse.release(MOUSE_LEFT); // zwolnienie przycisku
    }
  }
  Serial.println();
  delay(10);
}
