/*
 * Szkic interrupts
 * Schemat podłączeniowy znajdziesz w Recepturze 10.1 "Odbieranie sygnałów z pilota na podczerwień"
 */

const int pin = 2; // Pin, do którego podłączony jest odbiornik
const int numberOfEntries = 32; // Ustaw tą wartość na taką, która najbardziej odpowiada potrzebom Twojego projektu     

volatile unsigned long microseconds;
volatile byte idx = 0;
volatile unsigned long results[numberOfEntries];

void setup()
{
  pinMode(pin, INPUT_PULLUP);
  Serial.begin(9600);
  // Uzyj przerwań na pinie w celu monitorowania zmian
  attachInterrupt(digitalPinToInterrupt(pin), analyze, CHANGE);
  results[0]=0;
}

void loop()
{
  if(idx >= numberOfEntries)
  {
    Serial.println("Długości w mikrosekundach to: ") ;
    for( byte i=0; i < numberOfEntries; i++)
    {
      Serial.print(i); Serial.print(": ");
      Serial.println(results[i]);
    }
    idx = 0; // Zacznij ponowną analizę
  }
  delay(1000);
}

void analyze()
{
  if(idx < numberOfEntries)
  {
    if(idx > 0)
    {
      results[idx] = micros() - microseconds;
    }
    idx = idx + 1;
  }
  microseconds = micros();
}
