/* 
 * Szkic progmem
 * Używa tablicy zapisanej w pamięci flash do zamiany funkcji liniowej na wykładniczą
 */

#include <avr/pgmspace.h>  // Biblioteka wymagana dla tablicy PROGMEM

// Tablica wartości funkcji wykładniczej 
// Wartości od 0 do 255 wygenerowane za pomocą pętli for -> x=round( pow( 2.0, i/32.0) - 1);

const byte table[]PROGMEM = {
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,
   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   4,   4,   4,   4,   4,   4,   4,   4,   4,   5,
   5,   5,   5,   5,   5,   5,   5,   6,   6,   6,   6,   6,   6,   6,   7,   7,
   7,   7,   7,   8,   8,   8,   8,   8,   9,   9,   9,   9,   9,  10,  10,  10,
  10,  11,  11,  11,  11,  12,  12,  12,  12,  13,  13,  13,  14,  14,  14,  15,
  15,  15,  16,  16,  16,  17,  17,  18,  18,  18,  19,  19,  20,  20,  21,  21,
  22,  22,  23,  23,  24,  24,  25,  25,  26,  26,  27,  28,  28,  29,  30,  30,
  31,  32,  32,  33,  34,  35,  35,  36,  37,  38,  39,  40,  40,  41,  42,  43,
  44,  45,  46,  47,  48,  49,  51,  52,  53,  54,  55,  56,  58,  59,  60,  62,
  63,  64,  66,  67,  69,  70,  72,  73,  75,  77,  78,  80,  82,  84,  86,  88,
  90,  91,  94,  96,  98, 100, 102, 104, 107, 109, 111, 114, 116, 119, 122, 124,
 127, 130, 133, 136, 139, 142, 145, 148, 151, 155, 158, 161, 165, 169, 172, 176,
 180, 184, 188, 192, 196, 201, 205, 210, 214, 219, 224, 229, 234, 239, 244, 250
};

const int rawLedPin  = 3;           // Dioda przyciemniająca i rozjaśniająca się na podstawie wartości funkcji liniowej
const int adjustedLedPin = 5;       // Dioda sterowana wartościami z tablicy

int brightness = 0;
int increment = 1;

void setup()
{
  // Dla pinów sterowanych przez analogWrite nie trzeba ustawiać trybu wyjścia
}

void loop()
{
  if (brightness > 254)
  {
     increment = -1; // Odliczanie w dół po osiągnięciu 255
  }
  else if (brightness < 1)
  {
    increment =  1; // Odliczanie w górę po osiągnięciu 0
  }
  brightness = brightness + increment; // Inkrementacja (lub dekrementacja w przypadku znaku minus)

  // Zapisanie wartości jasności na pinach diod LED
  analogWrite(rawLedPin, brightness);  // Niezmieniona wartość
  int adjustedBrightness = pgm_read_byte(&table[brightness]);  // Dostosowana wartość
  analogWrite(adjustedLedPin, adjustedBrightness);

  delay(10); // 10 ms na każdy krok zmiany oznacza 2,55 s na rozjaśnienie i przyciemnienie
}
