/*
 * Szkic f
 * Zapisuje łańcuchy znaków w pamięci flash
 */
 
void setup()
{
  Serial.begin(9600); 
}

void loop()
{
  Serial.println(memoryFree());  // Wyświetlanie ilości wolnej pamięci

  Serial.println(F("Arduino"));  // Wyświetlanie łańcucha znaków
  delay(1000);
}

#ifdef __arm__
// Zmienna utworzona przez proces kompilacji
extern "C" char *sbrk(int incr); // Wywołaj z argumentem 0, aby otrzymać początkowy adres wolnej pamięci
#else
extern int *__brkval; // Wskaźnik na ostatni zapisany adres kopca (lub 0)
#endif

// Funkcja zwracająca ilość wolnej pamięci RAM
int memoryFree()
{
  int freeValue; // Ostatni umieszczony na stosie obiekt
#ifdef __arm__
  freeValue = &freeValue - reinterpret_cast<int*>(sbrk(0));
#else
  if((int)__brkval == 0) // Kopiec jest pusty, więc użyj początku kopca
  {
    freeValue = ((int)&freeValue) - ((int)__malloc_heap_start);
  }
  else // Kopiec nie jest pusty, więc użyj ostatniego adresu kopca
  {
    freeValue = ((int)&freeValue) - ((int)__brkval);
  }
#endif
  return freeValue;
}
